<!DOCTYPE html>
<html>

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><?php echo e($order->invoice_number); ?></title>

	<style>
		@page  {
			margin: 20px;
		}

        /* * {
			font-family: DejaVu Sans, sans-serif;
		} */

		body {
			margin: 20px;
			position: relative;
			width: 100%;
			height: auto;
			margin: 0 auto;
			color: #555555;
			background: #FFFFFF;
			font-size: 12px;
		}

		.invoice-box {
			max-width: 800px;
			margin: auto;

			font-size: 14px;
			line-height: 18px;
			color: #555;
		}

		.invoice-box table {
			width: 100%;
			line-height: inherit;
			text-align: left;
		}

		.invoice-box table td {
			padding: 5px;
			vertical-align: top;
		}

		.invoice-box table tr td:nth-child(5) {
			text-align: right;
		}

		.invoice-box table tr.top table td {
			padding-bottom: 20px;
		}

		.invoice-box table tr.information table td {
			padding-bottom: 40px;
		}

		.invoice-box table tr.heading td {
			background: #eee;
			border-bottom: 1px solid #ddd;
			font-weight: bold;
		}

		.invoice-box table tr.main-heading td {
			background: rgb(218, 218, 218);
			border-bottom: 1px solid #ddd;
			font-weight: bold;
		}

		.invoice-box table tr.details td {
			padding-bottom: 20px;
		}

		.invoice-box table tr.item td {
			border-bottom: 1px solid #eee;
		}

		.invoice-box table tr.item.last td {
			border-bottom: none;
		}

		@media  only screen and (max-width: 600px) {
			.invoice-box table tr.top table td {
				width: 100%;
				display: block;
				text-align: left;
			}

			.invoice-box table tr.information table td {
				width: 100%;
				display: block;
				text-align: left;
			}
		}

		/** RTL **/
		.invoice-box.rtl {
			direction: rtl;
			font-family: Tahoma, 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
		}

		.invoice-box.rtl table {
			text-align: left;
		}

		.invoice-box.rtl table tr td:nth-child(5) {
			text-align: right;
		}

		/** New CSS **/
		.text-left {
			text-align: left;
		}

		.text-right {
			text-align: right;
		}

		.text-center {
			text-align: center;
		}

		.divider {
			line-height: 1.5715;
			color: #000000d9;
			border-top: 1px solid rgba(0, 0, 0, .10);
		}

		.company-info {
			text-align: left;
		}

		.company-title {
			font-weight: bold;
			font-size: 18px;
		}

		p {
			margin: 0;
		}

		.clearfix {
			display: block;
			clear: both;
		}

		.mt-10 {
			margin-top: 10px;
		}

		.mt-20 {
			margin-top: 20px;
		}

		.total-bg {
			background: #eee;
		}
	</style>
</head>

<body>
	<div class="invoice-box">
		<table cellpadding="0" cellspacing="0">
			<tr class="main-heading">
				<?php if($order->order_type == "purchases"): ?>
				<td class="text-center"><?php echo e($traslations['purchase_invoice']); ?></td>
				<?php elseif($order->order_type == "purchase-returns"): ?>
				<td class="text-center"><?php echo e($traslations['purchase_return_invoice']); ?></td>
				<?php elseif($order->order_type == "sales-returns"): ?>
				<td class="text-center"><?php echo e($traslations['sales_return_invoice']); ?></td>
				<?php elseif($order->order_type == "sales"): ?>
				<td class="text-center"><?php echo e($traslations['sales_invoice']); ?></td>
				<?php endif; ?>
			</tr>
		</table>

		<table cellpadding="0" cellspacing="0">
			<tr class="top">
				<td>
					<img src="<?php echo e($company->light_logo_url); ?>" style="width: 200px; margin-top: 5px;" />
				</td>
				<td colspan="2">
					<table>
						<tr>
							<td style="vertical-align: middle;">
								<img src="<?php echo e($company->logo_url); ?>" style="width: 150px">
							</td>
							<td class="text-right">
								<span class="company-title">
									<?php echo e($company->name); ?> <br>
								</span>
								<span>
									<?php echo e($company->address); ?> <br>
									<?php echo e($company->email); ?> <br>
									<?php echo e($company->phone); ?>

								</span>
							</td>


						</tr>
					</table>
				</td>
			</tr>

		</table>

		<div class="divider"></div>

		<table cellpadding="0" cellspacing="0">
			<tr class="information">
				<td colspan="2">
					<table>
						<tr>
							<td class="text-left">
								<?php echo e($traslations['invoice']); ?> #: <?php echo e($order->invoice_number); ?><br />
								<?php echo e($traslations['order_date']); ?>: <?php echo e($order->order_date->format($dateTimeFormat)); ?><br />
								<?php echo e($traslations['order_status']); ?>: <?php echo e($order->order_status); ?><br />
								<?php echo e($traslations['payment_status']); ?>: <?php echo e($order->payment_status); ?>

							</td>

                            <?php if($order->order_type == 'stock-transfers'): ?>
							<td class="text-right">
								<b><?php echo e($traslations['bill_to']); ?></b><br />
								<?php echo e($order->warehouse->name); ?><br />
								<?php if($order->warehouse->addres): ?>
								<?php echo e($order->warehouse->address); ?> <br />
								<?php endif; ?>
								<?php if($order->warehouse->phone): ?>
								<?php echo e($order->warehouse->phone); ?> <br />
								<?php endif; ?>
								<?php echo e($order->warehouse->email); ?>

							</td>
                            <?php else: ?>
                                <td class="text-right">
                                    <b><?php if($order->order_type == "sales" || $order->order_type == "sales-returns"): ?> <?php echo e($traslations['bill_to']); ?> <?php elseif($order->order_type == "purchases" || $order->order_type == "purchase-returns"): ?> Bill From <?php endif; ?>:</b><br />
                                    <?php echo e($order->user->name); ?><br />
                                    <?php if($order->user->address || $order->user->city || $order->user->zipcode): ?>
                                    <?php echo e($order->user->address .'' .  $order->user->city .''. $order->user->zipcode); ?> <br />
                                    <?php endif; ?>
                                    <?php if($order->user->phone): ?>
                                    <?php echo e($order->user->phone); ?> <br />
                                    <?php endif; ?>
                                    <?php echo e($order->user->email); ?>

                                </td>
                            <?php endif; ?>
						</tr>
					</table>
				</td>
			</tr>
		</table>


		<table cellpadding="0" cellspacing="0">

			<tr class="heading">
				<td>#</td>
				<td><?php echo e($traslations['product']); ?></td>
				<td><?php echo e($traslations['unit_price']); ?></td>
				<td><?php echo e($traslations['quantity']); ?></td>
				<td><?php echo e($traslations['total']); ?></td>
			</tr>

			<?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<tr class="item">
				<td><?php echo e($loop->iteration); ?></td>
				<td><?php echo e($item->product->name); ?></td>
				<td><?php echo e($company->currency->symbol .''. $item->single_unit_price); ?></td>
				<td><?php echo e($item->quantity . ' ' . $item->unit->short_name); ?></td>
				<td><?php echo e($company->currency->symbol .''. $item->subtotal); ?></td>
			</tr>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

		</table>

		<div class="divider"></div>

		<div class="mt-20">
			<div style="width: 65%; float: left;">
				<p class="mt-20" style="font-weight: bold; font-size: 14px;">
					<?php echo e($traslations['notes']); ?>:
				</p>
				<p><?php echo e($order->notes); ?></p>
			</div>
			<div style="width: 30%; float: right;">
				<table cellpadding="0" cellspacing="0" class="mt-10">
					<tr>
						<td><?php echo e($traslations['subtotal']); ?></td>
						<td class="text-right"><?php echo e($company->currency->symbol .''. $order->subtotal); ?></td>
					</tr>
					<tr>
						<td><?php echo e($traslations['tax']); ?></td>
						<td class="text-right"><?php echo e($company->currency->symbol .''. $order->tax_amount); ?> (<?php echo e($order->tax_rate); ?>%)</td>
					</tr>
					<tr>
						<td><?php echo e($traslations['discount']); ?></td>
						<td class="text-right"><?php echo e($company->currency->symbol .''. $order->discount); ?></td>
					</tr>
					<tr>
						<td><?php echo e($traslations['shipping']); ?></td>
						<td class="text-right"><?php echo e($company->currency->symbol .''. $order->shipping); ?></td>
					</tr>
					<tr>
						<td class="total-bg"><b><?php echo e($traslations['total']); ?></b></td>
						<td class="text-right total-bg"><?php echo e($company->currency->symbol .''. $order->total); ?></td>
					</tr>
				</table>
			</div>
			<div class="clearfix"></div>
		</div>

		<div class="divider mt-10"></div>
		<table cellpadding="0" cellspacing="0">
			<tr class="heading">
				<td><?php echo e($traslations['total_items']); ?> / <?php echo e($traslations['qty']); ?> : <?php echo e($order->total_items . ' / ' . $order->total_quantity); ?></td>
				<td><?php echo e($traslations['paid_amount']); ?>: <?php echo e($company->currency->symbol .''. $order->paid_amount); ?></td>
				<td><?php echo e($traslations['due_amount']); ?>: <?php echo e($company->currency->symbol .''. $order->due_amount); ?></td>
			</tr>
		</table>
		<div class="divider"></div>

        <table cellpadding="0" cellspacing="0">
			<tr class="heading text-center">
				<td>
                    <?php echo e($traslations['payment_mode']); ?> :
                    <?php if($order->orderPayments): ?>
                    <?php $__currentLoopData = $order->orderPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currentOrderPayment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <span style="margin-right: 10px;">
                            <?php echo e($company->currency->symbol .'' . $currentOrderPayment->amount); ?>

                            <?php if($currentOrderPayment->payment && $currentOrderPayment->payment->paymentMode && $currentOrderPayment->payment->paymentMode->name): ?>
                                (<?php echo e($currentOrderPayment->payment->paymentMode->name); ?>)
                            <?php endif; ?>
                        </span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        -
                    <?php endif; ?>
                </td>
			</tr>
		</table>

	</div>
</body>

</html>
<?php /**PATH /home/mbbgloba/app.mbbglobalsupplier.in/resources/views/pdf.blade.php ENDPATH**/ ?>