<?php

namespace App\Classes;

use App\Models\Lang;
use App\Models\Translation;
use Nwidart\Modules\Facades\Module;

class LangTrans
{
    public static $mainTranslations = [
        'common' => [
            'enabled' => 'Enabled',
            'disabled' => 'Disabled',
            'id' => 'Id',
            'action' => 'Action',
            'placeholder_default_text' => 'Please Enter {0}',
            'placeholder_social_text' => 'Please Enter {0} Url',
            'placeholder_search_text' => 'Search By {0}',
            'select_default_text' => 'Select {0}...',
            'create' => 'Create',
            'edit' => 'Edit',
            'update' => 'Update',
            'cancel' => 'Cancel',
            'delete' => 'Delete',
            'success' => 'Success',
            'error' => 'Error',
            'yes' => 'Yes',
            'no' => 'No',
            'fix_errors' => 'Please Fix Below Errors.',
            'cancelled' => 'Cancelled',
            'pending' => 'Pending',
            'paid' => 'Paid',
            'completed' => 'Completed',
            'save' => 'Save',
            'all' => 'All',
            'name' => 'Name',
            'back' => 'Back',
            'max_amount' => 'Max. Amount',
            'date_time' => 'Date Time',
            'select_time' => 'Select Time',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'search' => 'Search',
            'date' => 'Date',
            'out_of_stock' => 'Out Of Stock',
            'pay' => 'Pay',
            'received' => 'Received',
            'with_tax' => 'With Tax',
            'without_tax' => 'Without Tax',
            'invoice_number' => 'Invoice Number',
            'ordered' => 'Ordered',
            'confirmed' => 'Confirmed',
            'processing' => 'Processing',
            'shipping' => 'Shipping',
            'delivered' => 'Delivered',
            'confirm' => 'Confirm',
            'title' => 'Title',
            'value' => 'Value',
            'add' => 'Add',
            'view' => 'View',
            'edit' => 'Edit',
            'download' => 'Download',
            'change_order_status' => 'Change Order Status',
            'total' => 'Total',
            'print_invoice' => 'Print Invoice',
            'email' => 'Email',
            'phone' => 'Phone',
            'item' => 'Item',
            'items' => 'Items',
            'qty' => 'Qty',
            'rate' => 'Rate',
            'purchase_code' => 'Purchase Code',
            'verify_purchase' => 'Verify Purchase',
            'buy_now' => 'Buy Now',
            'install' => 'Install',
            'installing' => 'Installing',
            'updating' => 'Updating',
            'free' => 'Free',
            'paid' => 'Paid',
            'domain' => 'Domain',
            'verify' => 'Verify',
            'send' => 'Send',
            'upload' => 'Upload',
            'view_all' => 'View All',
            'unpaid' => 'Unpaid',
            'loading' => 'Loading',
            'update_app' => 'Update App',
            'welcome_back' => 'Welcome {0}',
            'off' => 'Off',
            'on_create' => 'On Create',
            'on_update' => 'On Update',
            'on_delete' => 'On Delete',
            'demo_account_credentials' => 'Demo account login credentials',
            'balance' => 'Balance',
            'party' => 'Party',
            'created_by' => 'Created By',
            'import' => 'Import',
            'file' => 'File',
            'copy_url' => 'Copy Url',
            'print' => 'Print',
            'pdf' => 'Pdf',
            'particulars' => 'Particulars',
            'amount' => 'Amount',
            'profit' => 'Profit',
            'profit_reports_by_orders' => 'Profit Reports By Orders',
            'profit_reports_by_payments' => 'Profit Reports By Payments',
            'status' => 'Status',
            'active' => 'Active',
            'inactive' => 'Inactive',
            'verified' => 'Verified',
            'configure' => 'Configure',
            'logo' => 'Logo',
            'comment' => 'Comment',
            'rating' => 'Rating',
            'page_content' => 'Page Content',
            'slug' => 'Slug',
            'question' => 'Question',
            'answer' => 'Answer',
            'description' => 'Description',
            'image' => 'Image',
            'address' => 'Address',
            'not_allowed' => 'Not Allowed',
            'details' => 'Details',
            'excel' => 'Excel',
        ],
        'menu' => [
            'dashboard' => 'Dashboard',
            'stock_management' => 'Stock Manager',
            'purchase' => 'Purchase',
            'purchases' => 'Purchases',
            'purchase_returns' => 'Purchase Return / Dr. Note',
            'sales' => 'Sales',
            'sales_returns' => 'Sales Return / Cr. Note',
            'product_manager' => 'Product Manager',
            'brands' => 'Brands',
            'categories' => 'Categories',
            'products' => 'Products',
            'expense_manager' => 'Expenses',
            'expense_categories' => 'Expense Categories',
            'expenses' => 'Expenses',
            'users' => 'Users',
            'parties' => 'Parties',
            'staff_members' => 'Staff Members',
            'customers' => 'Customers',
            'suppliers' => 'Suppliers',
            'settings' => 'Settings',
            'company' => 'Company Settings',
            'profile' => 'Profile',
            'translations' => 'Translations',
            'languages' => 'Languages',
            'warehouses' => 'Warehouses',
            'roles' => 'Role & Permissions',
            'taxes' => 'Taxes',
            'currencies' => 'Currencies',
            'payment_modes' => 'Payment Modes',
            'units' => 'Units',
            'login' => 'Login',
            'logout' => 'Logout',
            'reports' => 'Reports',
            'order_payments' => 'Order Payments',
            'payments' => 'Payments',
            'stock_alert' => 'Stock Alert',
            'users_reports' => 'Users Reports',
            'warehouses_reports' => 'Warehouses Reports',
            'pos' => 'POS',
            'stock_adjustment' => 'Stock Adjustment',
            'verify_product' => 'Verify Product',
            'modules' => 'Modules',
            'storage_settings' => 'Storage Settings',
            'email_settings' => 'Email Settings',
            'update_app' => 'Update App',
            'custom_fields' => 'Custom Fields',
            'payment_in' => 'Payment In',
            'payment_out' => 'Payment Out',
            'cash_bank' => 'Cash & Bank',
            'sales_summary' => 'Sales Summary',
            'stock_summary' => 'Stock Summary',
            'rate_list' => 'Rate List',
            'product_sales_summary' => 'Product Sales Summary',
            'homepage' => 'Buy online products',
            'online_orders' => 'Online Orders',
            'website_setup' => 'Website Setup',
            'product_cards' => 'Product Cards',
            'front_settings' => 'Front Settings',
            'orders' => 'Orders',
            'quotations' => 'Quotations',
            'quotation' => 'Quotation',
            'quotation_estimate' => 'Quotation / Estimate',
            'database_backup' => 'Database Backup',
            'stock_transfer' => 'Stock Transfer',
            'stock_transfers' => 'Stock Transfers',
            'profit_loss' => 'Profit & Loss',
            'companies' => 'Companies',
            'pos_settings' => 'POS Settings',
            'setup_company' => 'Setup Company',
        ],
        'dashboard' => [
            'dashboard' => 'Dashboard',
            'recent_stock_history' => 'Recent Stock History',
            'top_selling_product' => 'Top Selling Product',
            'sales_purchases' => 'Sales & Purchases',
            'total_sales' => 'Total Sales',
            'top_customers' => 'Top Customers',
            'total_expenses' => 'Total Expenses',
            'payment_sent' => 'Payment Sent',
            'payment_received' => 'Payment Received',
            'total_sales_items' => 'Total Sales Items',
            'total_sales_returns_items' => 'Total Sales Returns Items',
            'total_purchases_items' => 'Total Purchase Items',
            'total_purchase_returns_items' => 'Total Purchase Returns Items',
        ],
        'user' => [
            'email_phone' => 'Email or Phone',
            'user' => 'User',
            'name' => 'Name',
            'created_at' => 'Created At',
            'email' => 'Email',
            'password' => 'Password',
            'login_enabled' => 'Login Enabled',
            'profile_image' => 'Profile Image',
            'company_name' => 'Company Name',
            'phone' => 'Phone Number',
            'address' => 'Address',
            'city' => 'City',
            'state' => 'State',
            'country' => 'Country',
            'zipcode' => 'Zipcode',
            'billing_address' => 'Billing Address',
            'shipping_address' => 'Shipping Address',
            'opening_balance' => 'Opening Balance',
            'credit_period' => 'Credit Period',
            'credit_limit' => 'Credit Limit',
            'to_receive' => 'To Collect',
            'to_pay' => 'To Pay',
            'receive' => 'Receive',
            'pay' => 'Pay',
            'status' => 'Status',
            'role' => 'Role',
            'days' => 'Day(s)',
            'profile_updated' => 'Profile Updated Successfully',
            'password_blank' => "Leave blank if you don't want to update password.",
            'total_sales' => "Total Sales",
            'total_purchases' => "Total Purchases",
            'walk_in_customer' => "Walk In Customer",
            'staff_members_details' => "Staff Member Details",
            'customers_details' => "Customer Details",
            'suppliers_details' => "Supplier Details",
            'admin_account_details' => "Admin Account Details",
            'tax_number' => 'Tax Number',
            'warehouse_not_changable' => 'Warehouse Can Not Be Changed',
        ],
        'staff_member' => [
            'add' => 'Add New Staff Member',
            'edit' => 'Edit Staff Member',
            'created' => 'Staff Member Created Successfully',
            'updated' => 'Staff Member Updated Successfully',
            'deleted' => 'Staff Member Deleted Successfully',
            'staff_member_details' => 'Staff Member Details',
            'staff_member' => 'Staff Member',
            'delete_message' => 'Are you sure you want to delete this staff member?',
            'import_staff_members' => 'Import Staff Members',
        ],
        'customer' => [
            'add' => 'Add New Customer',
            'edit' => 'Edit Customer',
            'created' => 'Customer Created Successfully',
            'updated' => 'Customer Updated Successfully',
            'deleted' => 'Customer Deleted Successfully',
            'customer_details' => 'Customer Details',
            'delete_message' => 'Are you sure you want to delete this customer?',
            'import_customers' => 'Import Customers',
        ],
        'supplier' => [
            'add' => 'Add New Supplier',
            'edit' => 'Edit Supplier',
            'created' => 'Supplier Created Successfully',
            'updated' => 'Supplier Updated Successfully',
            'deleted' => 'Supplier Deleted Successfully',
            'supplier_details' => 'Supplier Details',
            'delete_message' => 'Are you sure you want to delete this supplier?',
            'import_suppliers' => 'Import Suppliers',
        ],
        'warehouse' => [
            'add' => 'Add New Warehouse',
            'edit' => 'Edit Warehouse',
            'created' => 'Warehouse Created Successfully',
            'updated' => 'Warehouse Updated Successfully',
            'deleted' => 'Warehouse Deleted Successfully',
            'warehouse_details' => 'Warehouse Details',
            'warehouse' => 'Warehouse',
            'logo' => 'Logo',
            'dark_logo' => 'Dark Logo',
            'name' => 'Name',
            'slug' => 'Slug',
            'email' => 'Email',
            'phone' => 'Phone',
            'address' => 'Billing Address',
            'show_email_on_invoice' => 'Show email on invoice',
            'show_phone_on_invoice' => 'Show phone on invoice',
            'terms_condition' => 'Terms & Conditions',
            'bank_details' => 'Bank Details',
            'signature' => 'Signature',
            'delete_message' => 'Are you sure you want to delete this warehouse?',
            'details_will_be_shown_on_invoice' => 'Note: Details added below will be shown on your invoices',
            'online_store' => 'Online Store',
            'online_store_status_updated' => 'Online store status updated successfully',
            'no_online_store_exists' => 'No online store exists for this url. Please contact to admin for support.',
            'view_online_store' => 'View Online Store',
            'default_pos_order_status' => 'POS Default Status',
            'basic_details' => 'Basic Details',
            'visibility' => 'Visibility',
            'customers_visibility' => 'Customers Visibility',
            'suppliers_visibility' => 'Suppliers Visibility',
            'products_visibility' => 'Products Visibility',
            'view_all_customers' => 'View All Customers',
            'view_warehouse_customers' => 'View Only Warehouse Customers',
            'view_all_suppliers' => 'View All Suppliers',
            'view_warehouse_suppliers' => 'View Only Warehouse Suppliers',
            'view_all_products' => 'View All Products',
            'view_warehouse_products' => 'View Only Warehouse Products',
        ],
        'front_website' => [
            'home' => 'Home',
            'features' => 'Features',
            'pricing' => 'Pricing',
            'contact' => 'Contact',
            'links' => 'Links',
            'pages' => 'Pages',
            'register' => 'Register',
            'company_name' => 'Company Name',
            'email' => 'Email',
            'password' => 'Password',
            'confirm_password' => 'Confirm Password',
            'login' => 'Login',
            'first_name' => 'First Name',
            'last_name' => 'Last Name',
            'address' => 'Address',
            'email' => 'Email',
            'phone' => 'Phone',
            'send_message' => 'Send Message',
            'register_thank_you' => 'Thank you for registration. Please login to get started',
            'error_contact_support' => 'Some error occurred when inserting the data. Please try again or contact support',
            'contact_us_submit_message' => 'Thanks for contacting us. We will catch you soon.',
        ],
        'role' => [
            'add' => 'Add New Role',
            'edit' => 'Edit Role',
            'created' => 'Role Created Successfully',
            'updated' => 'Role Updated Successfully',
            'deleted' => 'Role Deleted Successfully',
            'role_details' => 'Role Details',
            'delete_message' => 'Are you sure you want to delete this role?',
            'display_name' => 'Display Name',
            'role_name' => 'Role Name',
            'description' => 'Description',
            'user_management' => 'User Management',
            'permissions' => 'Permissions',
        ],
        'company' => [
            'add' => 'Add New Company',
            'edit' => 'Edit Company',
            'created' => 'Company Created Successfully',
            'updated' => 'Company Updated Successfully',
            'deleted' => 'Company Deleted Successfully',
            'currency_details' => 'Company Details',
            'delete_message' => 'Are you sure you want to delete this company?',
            'name' => 'Company Name',
            'short_name' => 'Company Short Name',
            'email' => 'Company Email',
            'phone' => 'Company Phone',
            'address' => 'Company Address',
            'currency' => 'Currency',
            'logo' => 'Company Logo',
            'left_sidebar_theme' => 'Left Sidebar Theme',
            'dark' => 'Dark',
            'light' => 'Light',
            'dark_logo' => 'Dark Logo',
            'light_logo' => 'Light Logo',
            'small_dark_logo' => 'Small Dark Logo',
            'small_light_logo' => 'Small Light Logo',
            'primary_color' => 'Primary Color',
            'default_timezone' => 'Default Timezone',
            'date_format' => 'Date Format',
            'time_format' => 'Time Format',
            'auto_detect_timezone' => 'Auto Detect Timezone',
            'app_debug' => 'App Debug',
            'update_app_notification' => 'Update App Notitication',
            'login_image' => 'Login Image',
            'layout' => 'Layout',
            'rtl' => 'RTL',
            'ltr' => 'LTR',
            'shortcut_menu_Placement' => 'Add Menu Placement',
            'top_and_bottom' => 'Top & Bottom',
            'top_header' => 'Top Header',
            'bottom_corner' => 'Bottom Conrer',
            'shortcut_menu_setting' => 'Add Menu Settings',
            'menu_setting_updated' => 'Menu Setting Updated',
            'basic_details' => 'Basic Details',
            'details' => 'Details',
            'register_date' => 'Register Date',
            'total_users' => 'Total Users',
        ],
        'tax' => [
            'add' => 'Add New Tax',
            'edit' => 'Edit Tax',
            'created' => 'Tax Created Successfully',
            'updated' => 'Tax Updated Successfully',
            'deleted' => 'Tax Deleted Successfully',
            'tax_details' => 'Tax Details',
            'delete_message' => 'Are you sure you want to delete this tax?',
            'display_name' => 'Display Name',
            'name' => 'Name',
            'rate' => 'Tax Rate',
            'no_tax' => 'No Tax',
        ],
        'currency' => [
            'add' => 'Add New Currency',
            'edit' => 'Edit Currency',
            'created' => 'Currency Created Successfully',
            'updated' => 'Currency Updated Successfully',
            'deleted' => 'Currency Deleted Successfully',
            'currency_details' => 'Currency Details',
            'delete_message' => 'Are you sure you want to delete this currency?',
            'name' => 'Currency Name',
            'symbol' => 'Currency Symbol',
            'position' => 'Currency Position',
            'front' => 'Front',
            'front_position_example' => 'Example : $100',
            'behind' => 'Behind',
            'behind_position_example' => 'Example : 100$',
            'code' => 'Currency Code',
        ],
        'payment_mode' => [
            'add' => 'Add New Payment Mode',
            'edit' => 'Edit Payment Mode',
            'created' => 'Payment Mode Created Successfully',
            'updated' => 'Payment Mode Updated Successfully',
            'deleted' => 'Payment Mode Deleted Successfully',
            'payment_mode_details' => 'Payment Mode Details',
            'delete_message' => 'Are you sure you want to delete this payment mode?',
            'name' => 'Payment Mode Name',
            'mode_type' => 'Mode Type',
            'cash' => 'Cash',
            'bank' => 'Bank',
        ],
        'unit' => [
            'add' => 'Add New Unit',
            'edit' => 'Edit Unit',
            'created' => 'Unit Created Successfully',
            'updated' => 'Unit Updated Successfully',
            'deleted' => 'Unit Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this unit?',
            'unit_details' => 'Unit Details',
            'name' => 'Unit Name',
            'short_name' => 'Short Name',
            'base_unit' => 'Base Unit',
            'operator' => 'Operator',
            'operator' => 'Operator',
            'multiply' => 'Multiply (*)',
            'divide' => 'Divide (/)',
            'operator_value' => 'Operator Value',
        ],
        'custom_field' => [
            'add' => 'Add New Custom Field',
            'edit' => 'Edit Custom Field',
            'created' => 'Custom Field Created Successfully',
            'updated' => 'Custom Field Updated Successfully',
            'deleted' => 'Custom Field Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this custom field?',
            'name' => 'Field Name',
            'value' => 'Default Value',
            'type' => 'Field Type',
        ],
        'module' => [
            'name' => 'Module Name',
            'verified' => 'Verified',
            'verify_purchase_code' => 'Verify Purchase Code',
            'current_version' => 'Current Version',
            'latest_version' => 'Latest Version',
            'status' => 'Status',
            'installed_modules' => 'Installed Modules',
            'other_modules' => 'Other Modules',
            'module_status_updated' => 'Modules Status Updated',
            'downloading_completed' => 'Download Completed',
            'extract_zip_file' => 'Extract Zip File',
            'file_extracted' => 'Zip File Extracted',
        ],
        'update_app' => [
            'app_details' => 'App Details',
            'name' => 'Name',
            'value' => 'Value',
            'php_version' => 'PHP Version',
            'app_version' => 'App Version',
            'laravel_version' => 'Laravel Version',
            'mysql_version' => 'MySQL Version',
            'vue_version' => 'Vue Version',
            'update_app' => 'Update App',
            'update_now' => 'Update Now',
            'update_available' => 'Update Available',
            'verify_again' => 'Verify Again',
            'verify_failed' => 'Verification Failed',
            'verify_failed_message' => 'Your application is not registerd with us. Please verify it',
            'verified_with_other_domain' => 'Your purchase code is registerd with other doamin. Please verfiy your purhcase code',
        ],
        'expense_category' => [
            'add' => 'Add New Expense Category',
            'edit' => 'Edit Expense Category',
            'created' => 'Expense Category Created Successfully',
            'updated' => 'Expense Category Updated Successfully',
            'deleted' => 'Expense Category Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this expense category?',
            'expense_category_details' => 'Expense Category Details',
            'name' => 'Expense Category Name',
            'description' => 'Description',
        ],
        'expense' => [
            'add' => 'Add New Expense',
            'edit' => 'Edit Expense',
            'created' => 'Expense Created Successfully',
            'updated' => 'Expense Updated Successfully',
            'deleted' => 'Expense Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this expense?',
            'details' => 'Expense Details',
            'warehouse' => 'Warehouse',
            'expense_category' => 'Expense Category',
            'date' => 'Date',
            'amount' => 'Amount',
            'bill' => 'Expense Bill',
            'user' => 'User',
            'created_by_user' => 'User',
            'notes' => 'Notes',
        ],
        'brand' => [
            'add' => 'Add New Brand',
            'edit' => 'Edit Brand',
            'created' => 'Brand Created Successfully',
            'updated' => 'Brand Updated Successfully',
            'deleted' => 'Brand Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this brand?',
            'details' => 'Brand Details',
            'name' => 'Name',
            'slug' => 'Slug',
            'logo' => 'Brand Logo',
            'import_brands' => 'Import Brands',
        ],
        'category' => [
            'add' => 'Add New Category',
            'edit' => 'Edit Category',
            'created' => 'Category Created Successfully',
            'updated' => 'Category Updated Successfully',
            'deleted' => 'Category Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this category?',
            'details' => 'Category Details',
            'category' => 'Category',
            'name' => 'Name',
            'slug' => 'Slug',
            'logo' => 'Category Logo',
            'parent_category' => 'Parent Category',
            'no_parent_category' => 'No Parent Category',
            'import_categories' => 'Import Categories',
        ],
        'product' => [
            'add' => 'Add New Product',
            'edit' => 'Edit Product',
            'created' => 'Product Created Successfully',
            'updated' => 'Product Updated Successfully',
            'deleted' => 'Product Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this product?',
            'details' => 'Product Details',
            'name' => 'Name',
            'slug' => 'Slug',
            'sku' => 'SKU',
            'image' => 'Image',
            'quantitiy_alert' => 'Quantity Alert',
            'brand' => 'Brand',
            'category' => 'Category',
            'price' => 'Price',
            'mrp' => 'MRP',
            'purchase_price' => 'Purchase Price',
            'sales_price' => 'Sales Price',
            'tax_type' => 'Tax Type',
            'description' => 'Description',
            'product' => 'Product',
            'quantity' => 'Quantity',
            'discount' => 'Discount',
            'tax' => 'Tax',
            'subtotal' => 'SubTotal',
            'unit' => 'Unit',
            'unit_price' => 'Unit Price',
            'avl_qty' => 'Avl. qty:',
            'order_items' => 'Order Items',
            'inclusive' => 'Inclusive',
            'exclusive' => 'Exclusive',
            'stocks' => 'Stocks',
            'stock_quantity' => 'Stock Quantity',
            'product_orders' => 'Product Orders',
            'stock_history' => 'Stock History',
            'current_stock' => 'Current Stock',
            'item_code' => 'Item Code',
            'barcode_symbology' => 'Barcode Symbology',
            'barcode' => 'Barcode',
            'view_barcode' => 'View Barcode',
            'generate_barcode' => 'Generate Barcode',
            'print_barcode' => 'Print Barcode',
            'price_tax' => 'Price & Tax',
            'custom_fields' => 'Custom Fields',
            'wholesale_rate' => 'Wholesale Rate',
            'wholesale_price' => 'Wholesale Price',
            'wholesale_quantity' => 'Wholesale Quantity',
            'enter_min_quantity' => 'Enter Minimum Quantity',
            'opening_stock' => 'Opening Stock',
            'opening_stock_date' => 'Opening Stock Date',
            'stock_value' => 'Stock Value',
            'by_purchase' => 'By Purchase',
            'by_sales' => 'By Sales',
            'unit_sold' => 'Unit Sold',
            'import_products' => 'Import Products',
        ],
        'stock' => [
            'order_type' => 'Order Type',
            'order_date' => 'Order Date',
            'warehouse' => 'Warehouse',
            'supplier' => 'Supplier',
            'customer' => 'Customer',
            'product' => 'Product',
            'invoice_number' => 'Invoice Number',
            'invoie_number_blank' => 'Leave it blank to generate automatically',
            'notes' => 'Notes',
            'status' => 'Order Status',
            'order_tax' => 'Order Tax',
            'discount' => 'Discount',
            'shipping' => 'Shipping',
            'grand_total' => 'Grand Total',
            'remarks' => 'Remarks',
            'pay_now' => 'Pay Now',
            'reset' => 'Reset',
            'total_items' => 'Total Items',
            'paying_amount' => 'Paying Amount',
            'payable_amount' => 'Payable Amount',
            'change_return' => 'Change Return',
            'order_details' => 'Order Details',
            'order_canceled' => 'Order Canceled Successfully',
            'order_cancel_message' => 'Are you sure you want to cancel this order?',
            'view_order' => 'View Order',
            'order_id' => 'Order Id',
            'shipping_address' => 'Shipping Address',
            'billing_address' => 'Billing Address',
            'order_taken_by' => 'Order Taken By',
            'no_product_found' => 'No product found for selected resource',
            'sold_by' => 'Sold By',
            'complete_order' => 'Complete Order',
        ],
        'purchase' => [
            'add' => 'Add New Purchase',
            'edit' => 'Edit Purchase',
            'details' => 'Purchase Details',
            'created' => 'Purchase Created Successfully',
            'updated' => 'Purchase Updated Successfully',
            'deleted' => 'Purchase Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this purchase?',
            'purchase_date' => 'Purchase Date',
            'purchase_status' => 'Purchase Status',
            'user' => 'Supplier',
        ],
        'sales' => [
            'add' => 'Add New Sales',
            'edit' => 'Edit Sales',
            'details' => 'Sales Details',
            'created' => 'Sales Created Successfully',
            'updated' => 'Sales Updated Successfully',
            'deleted' => 'Sales Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this sales?',
            'sales_date' => 'Sales Date',
            'sales_status' => 'Sales Status',
            'user' => 'Customer',
            'tax_invoice' => 'TAX INVOICE',
            'invoice' => 'Invoice',
        ],
        'purchase_returns' => [
            'add' => 'Add New Purchase Return',
            'edit' => 'Edit Purchase Return',
            'details' => 'Purchase Return Details',
            'created' => 'Purchase Return Created Successfully',
            'updated' => 'Purchase Return Updated Successfully',
            'deleted' => 'Purchase Return Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this purchase return?',
            'purchase_returns_date' => 'Return Date',
            'purchase_returns_status' => 'Return Status',
            'user' => 'Supplier',
        ],
        'sales_returns' => [
            'add' => 'Add New Sales Return',
            'edit' => 'Edit Sales Return',
            'details' => 'Sales Return Details',
            'created' => 'Sales Return Created Successfully',
            'updated' => 'Sales Return Updated Successfully',
            'deleted' => 'Sales Return Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this sales return?',
            'sales_returns_date' => 'Return Date',
            'sales_returns_status' => 'Return Status',
            'user' => 'Customer',
        ],
        'quotation' => [
            'add' => 'Add New Quotation',
            'edit' => 'Edit Quotation',
            'details' => 'Quotation Details',
            'created' => 'Quotation Created Successfully',
            'updated' => 'Quotation Updated Successfully',
            'deleted' => 'Quotation Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this quotation/estimate?',
            'quotation_date' => 'Quotation Date',
            'quotation_status' => 'Quotation Status',
            'user' => 'Customer',
            'tax_invoice' => 'TAX INVOICE',
            'invoice' => 'Invoice',
            'convert_to_sale' => 'Convert to sale',
            'convert_message' => 'Are you really want to convert this quotation to sales?',
            'quotation_converted_to_sales' => 'Quotation converted to sales successfully.',
        ],
        'payments' => [
            'add' => 'Add New Payment',
            'edit' => 'Edit Payment',
            'details' => 'Payment Details',
            'created' => 'Payment Created Successfully',
            'updated' => 'Payment Updated Successfully',
            'deleted' => 'Payment Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this payment?',
            'user' => 'User',
            'amount' => 'Amount',
            'invoice_amount' => 'Invoice Amount',
            'payment_number' => 'Reference Number',
            'payments' => 'Payments',
            'date' => 'Payment Date',
            'due_amount' => 'Due Amount',
            'paid_amount' => 'Paid Amount',
            'total_amount' => 'Total Amount',
            'unused_amount' => 'Unused Amount',
            'settled_amount' => 'Settled Amount',
            'payment_mode' => 'Payment Mode',
            'paid_total_amount' => 'Paid/Total Amount',
            'notes' => 'Notes',
            'payment_status' => 'Payment Status',
            'unpaid' => 'Unpaid',
            'paid' => 'Paid',
            'transactions' => 'Transactions',
            'transaction_number' => 'Txns No.',
            'partially_paid' => 'Partially Paid',
            'order_payment' => 'Order Payment',
            'settle_invoice_using_payment' => 'Settle below invoices using this payment',
            'payment_type' => 'Payment Type',
            'you_will_pay' => 'You Will Pay',
            'you_will_receive' => 'You Will Receive',
            'cash' => 'Cash',
            'bank' => 'Bank',
        ],
        'langs' => [
            'add' => 'Add New Language',
            'edit' => 'Edit Language',
            'details' => 'Language Details',
            'created' => 'Language Created Successfully',
            'updated' => 'Language Updated Successfully',
            'deleted' => 'Language Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this language?',
            'view_all_langs' => 'View All Languages',
            'status_updated' => 'Langugage status updated',
            'name' => 'Name',
            'key' => 'Key',
            'flag' => 'Flag',
            'enabled' => 'Enabled',
        ],
        'translations' => [
            'fetch_new_translations' => 'Fetch New Translations',
            'reload_translations' => 'Reload Translations',
            'reload_successfully' => 'Translations Reload Successfully',
            'fetched_successfully' => 'Translations Fetch Successfully',
            'import_translations' => 'Import Translations',
        ],
        'storage_settings' => [
            'updated' => 'Storage Settings Updated',
            'storage' => 'Storage',
            'local' => 'Local',
            'aws' => 'AWS S3 Storage',
            'aws_key' => 'AWS Key',
            'aws_secret' => 'AWS Secret',
            'aws_region' => 'AWS Region',
            'aws_bucket' => 'AWS Bucket',
        ],
        'mail_settings' => [
            'updated' => 'Mail Settings Updated',
            'mail_driver' => 'Mail Driver',
            'none' => 'None',
            'mail' => 'Mail',
            'smtp' => 'SMTP',
            'from_name' => 'Mail From Name',
            'from_email' => 'Mail From Email',
            'host' => 'Host',
            'port' => 'Port',
            'encryption' => 'Encryption',
            'username' => 'Username',
            'password' => 'Password',
            'send_test_mail' => 'Send Test Mail',
            'send_mail_setting_saved' => 'Send mail setting saved',
            'enable_mail_queue' => 'Enable Mail Queue',
            'send_mail_for' => 'Send Mail For',
            'email' => 'Email address for which you want to send test mail',
            'test_mail_sent_successfully' => 'Test mail sent successfully',
            'stock_adjustment_create' => 'Stock Adjustment Create',
            'notificaiton_will_be_sent_to_warehouse' => 'Notification will be sent to warehouse email',
        ],
        'online_orders' => [
            'order_summary' => 'Order Summary',
            'cancel_order' => 'Cancel Order',
            'order_cancelled' => 'Order Cancelled',
            'order_cancelled_message' => 'This order has been cancelled.',
            'cancel_message' => 'Are you sure you want to cancel this online order',
            'deliver_message' => 'Are you sure you want to this order as delivered',
            'order_cancelled' => 'Order cancelled successfully',
            'order_confirmed' => 'Order confirmed successfully',
            'order_status_changed' => 'Order status changed successfully',
            'online_orders_date' => 'Order Date',
            'online_orders_status' => 'Order Status',
            'update_orders_status' => 'Update Order Status',
            'confirm_delivery' => 'Confirm Delivery',
            'order_delivered' => 'Order delivered successfully',
            'user' => 'Customer',
            'online_store_url' => 'Online Store Url',
        ],
        'product_card' => [
            'add' => 'Add New Product Card',
            'edit' => 'Edit Product Card',
            'details' => 'Product Card Details',
            'created' => 'Product Card Created Successfully',
            'updated' => 'Product Card Updated Successfully',
            'deleted' => 'Product Card Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this product card?',
            'title' => 'Title',
            'subtitle' => 'Subtitle',
            'products' => 'Products',
        ],
        'front_setting' => [
            'products' => 'Products',
            'featured_categories' => 'Featured Categories',
            'featured_categories_title' => 'Featured Categories Title',
            'featured_categories_subtitle' => 'Featured Categories Subtitle',
            'featured_products' => 'Featured Products',
            'featured_products_title' => 'Featured Products Title',
            'featured_products_subtitle' => 'Featured Products Subtitle',
            'social_links' => 'Social Links',
            'facebook' => 'Facebook',
            'twitter' => 'Twitter',
            'instagram' => 'Instagram',
            'linkedin' => 'Linkedin',
            'youtube' => 'Youttube',
            'footer' => 'Footer',
            'banners' => 'Banners',
            'placeholder_social_text' => 'Please Enter {0} Url',
            'footers' => 'Footers',
            'copyright_text' => 'Copyright Text',
            'addLink' => 'Add Link',
            'addContactLink' => 'Add Contact Link',
            'addPageDetails' => 'Add Pages Details',
            'required_text' => '{0} Required',
            'footer_page_widget' => 'Footer Page Widget',
            'footer_contact_widget' => 'Footer Contact Widget',
            'footer_links_widget' => 'Footer Links Widget',
            'bottom_banners' => 'Bottom Banners',
            'top_banners_1' => 'Top Banner 1',
            'top_banners_2' => 'Top Banner 2',
            'top_banners_3' => 'Top Banner 3',
            'add_to_cart' => 'Add To Cart',
            'footer_company_description' => 'Footer Company Description',
            'useful_links' => 'Useful Links',
            'pages' => 'Pages',
            'contact' => 'Contact',
            'all_categories' => 'All Categories',
            'no_results' => 'No Results',
            'seo_keywords' => 'SEO Keywords',
            'seo_description' => 'SEO Description',
        ],
        'stock_adjustment' => [
            'add' => 'Add New Adjustment',
            'edit' => 'Edit Adjustment',
            'details' => 'Adjustment Details',
            'created' => 'Adjustment Created Successfully',
            'updated' => 'Adjustment Updated Successfully',
            'deleted' => 'Adjustment Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this stock adjustment?',
            'notes' => 'Notes',
            'current_stock' => 'Current Stock',
            'quantity' => 'Quantity',
            'adjustment_type' => 'Adjustment Type',
            'adjustment_add' => 'Add',
            'adjustment_subtract' => 'Subtract',
        ],
        'stock_transfer' => [
            'add' => 'Add New Transfer',
            'edit' => 'Edit Transfer',
            'details' => 'Transfer Details',
            'created' => 'Transfer Created Successfully',
            'updated' => 'Transfer Updated Successfully',
            'deleted' => 'Transfer Deleted Successfully',
            'delete_message' => 'Are you sure you want to delete this stock adjustment?',
            'stock_transfer_date' => 'Stock Transfer Date',
            'stock_transfer_status' => 'Stock Transfer Status',
            'from_warehouse' => 'From Warehouse',
            'to_warehouse' => 'To Warehouse',
            'warehouse' => 'Warehouse',
            'products' => 'Products',
            'notes' => 'Notes',
            'quantity' => 'Quantity',
            'created_by' => 'Created By',
            'received' => 'Received',
            'transfered' => 'Transfered',
        ],
        'database_backup' => [
            'file' => 'File',
            'file_size' => 'File Size',
            'generate_backup' => 'Generate Backup',
            'delete_backup' => 'Delete Backup',
            'backup_generated_successfully' => 'Backup Generated Successfully',
            'are_you_sure_generate_backup' => 'Are you sure you want to generate database backup?',
            'are_you_sure_delete_backup' => 'Are you sure you want to delete this database backup?',
            'backup_locaion_is' => 'All generated database file will be stored in storage/app/public/backup folder. ',
            'settings' => 'Command Settings',
            'backup_command_setting' => 'Backup Command Settings',
            'mysqldump_command_path' => 'mysqldump command path',
            'command_updated' => 'Command updated successfully',
            'window_command_path' => 'If you use XAMPP then it will be => C:\xampp\mysql\bin\mysqldump.exe',
            'laragon_command_path' => 'If you use Laragon then it will be => C:\laragon\bin\mysql\mysql-5.7.24-winx64\bin\mysqldump.exe',
            'linux_command_path' => 'If you are on ubuntu or mac then run following command and enter output here => which mysqldump',
            'put_dump_path_command_on_env_file' => 'Find your MySQL dump path from below and then add it to the DUMP_PATH inside .env file',
        ],
        'messages' => [
            'product_out_of_stock' => 'Product is out of stock. Current Stock is {0} while required stock is {1}.',
            'leave_blank_to_create_parent_category' => 'Leave it blank to create parent category',
            'somehing_went_wrong' => 'Something went wrong. Please contact to administrator.',
            'verify_success' => 'Successfully verified. Redirect to app...',
            'login_success' => 'Successfully login. Redirect to app...',
            'login_success_dashboard' => 'Successfully logged into app.',
            'click_here_to_find_purchase_code' => 'Click here to find your purchase code',
            'verification_successfull' => 'Verification successfully',
            'other_domain_linked' => 'Other domain linked',
            'other_domain_linked_with_purchase_code' => 'Other domain is already linked with your purchase code. Please enter your purchase code for more details...',
            'first_verify_module_message' => 'To enable please \n verify this module',
            'are_you_sure_install_message' => 'Are you sure you want to install?',
            'downloading_started_message' => 'Downloading started. Please wait ...',
            'file_extracting_message' => 'File extracteding. Please wait ...',
            'installation_success' => 'Installation successfully. Click here to reload page...',
            'are_you_sure_update_message' => 'Are you sure you want to update? Please take backup before update.',
            'stmp_success_message' => 'Your SMTP settings are correct..',
            'stmp_error_message' => 'Your SMTP settings are incorrect. Please update it to send mails',
            'uploading_failed' => 'Uploading failed',
            'loading_app_message' => 'Please wait... we are preparing something amazing for you',
            'fetching_product_details' => 'We are fetching product details. Please wait...',
            'product_is_upto_date' => 'You are on the latest version of app.',
            'new_app_version_avaialbe' => 'New app version {0} is available. Please update to get latest version.',
            'not_able_to_edit_order' => 'Only order status editable, other fields can not be editable becuase this order linked to some payments. Delete those payment(s) and try again.',
            'click_here_to_download_sample_file' => 'Click here to download sample csv file',
            'imported_successfully' => 'Imported Successfully',
            'company_admin_password_message' => 'Admin will login using this password. (Leave blank to keep current password)',
            'email_setting_not_configured' => 'Email setting not configured',
            'please_configure_email_settings' => 'Please configure your email settings to send emails. Click Here to configure email settings.',
        ],
        'popover' => [
            'quantitiy_alert' => 'After this stock quanity it will enable low stock warning.',
            'auto_detect_timezone' => 'Allow auto detect timezone from browser for currently logged in user.',
            'click_here_to_copy_credentials' => 'Click here to copy {0} credentials',
        ],
        'invoice' => [
            'purchase_invoice' => 'Purchase Invoice',
            'purchase_return_invoice' => 'Purchase Return Invoice',
            'sales_invoice' => 'Sales Invoice',
            'sales_return_invoice' => 'Sales Return Invoice',
            'invoice' => 'Invoice',
            'order_date' => 'Date',
            'order_status' => 'Status',
            'payment_status' => 'Payment Status',
            'bill_to' => 'Bill To',
            'product' => 'Product',
            'unit_price' => 'Unit Price',
            'quantity' => 'Quantity',
            'total' => 'Total',
            'notes' => 'Notes',
            'subtotal' => 'Subtotal',
            'tax' => 'Tax',
            'discount' => 'Discount',
            'shipping' => 'Shipping',
            'total_items' => 'Total Items',
            'qty' => 'Qty',
            'paid_amount' => 'Paid Amount',
            'due_amount' => 'Due Amount',
            'payment_mode' => 'Payment Mode',
            'thanks_message' => 'Thank You For Shopping With Us. Please Come Again',
        ],
        'front' => [
            'home' => 'Home',
            'profile' => 'Profile',
            'dashboard' => 'Dashboard',
            'my_orders' => 'My Orders',
            'my_profile' => 'My Profile',
            'logout' => 'Logout',
            'total_orders' => 'Total Orders',
            'pending_orders' => 'Pending Orders',
            'processing_orders' => 'Processing Orders',
            'completed_orders' => 'Completed Orders',
            'recent_orders' => 'Recent Orders',
            'order_history' => 'Order History',
            'profile_settings' => 'Profile Settings',
            'select_shipping_address' => 'Select Shipping Address',
            'checkout_page' => 'Checkout Page',
            'address_details' => 'Address Details',
            'payment_details' => 'Payment Details',
            'add_new_address' => 'Add New Address',
            'cash_on_delivery' => 'Cash On Delivery',
            'continue_shopping' => 'Continue Shopping',
            'confirm_order' => 'Confirm Order',
            'confirm_order_message' => 'Are you sure you want to confirm this order?',
            'order_placed' => 'Order placeded.',
            'order_placed_message' => 'Order placed successfully.',
            'all_orders' => 'All Orders',
            'follow_us' => 'Follow Us',
            'categories' => 'Categories',
            'pages' => 'Pages',
            'address_deleted' => 'Address Deleted',
            'address_saved' => 'Address Saved',
            'address_delete_message' => 'Are you sure you want to delete this address?',
            'setting_updated_successfully' => 'Setting updated successfully',
            'login' => 'Login',
            'login_using_email_password' => 'Login using email and password',
            'logged_in_successfully' => 'Logged in successfully',
            'dont_have_account' => "Don't have account?",
            'signup' => "Signup",
            'signup_using_email_password' => "Signup using email & password",
            'already_have_account' => "Already have account",
            'register_successfully' => "Registered successfully",
            'click_here_to_login' => "Click here to login",
        ],
        'topbar_add_button' => [
            'add_staff_member' => 'Add Staff Member',
            'add_customer' => 'Add Customer',
            'add_supplier' => 'Add Supplier',
            'add_brand' => 'Add Brand',
            'add_category' => 'Add Category',
            'add_product' => 'Add Product',
            'add_sales' => 'Add Sales',
            'add_purchase' => 'Add Purchase',
            'add_expense_cateogory' => 'Add Expense Category',
            'add_expense' => 'Add Expense',
            'add_currency' => 'Add Currency',
            'add_warehouse' => 'Add Warehouse',
            'add_unit' => 'Add Unit',
            'add_language' => 'Add Language',
            'add_role' => 'Add Role',
            'add_tax' => 'Add Tax',
            'add_payment_mode' => 'Add Payment Mode',
        ],
        'setup_company' => [
            'setup_not_completed' => 'Setup Not Completed',
            'setup_not_completed_description' => 'Your company default settings not completed. Follow below setups to complete your company basic settings...',
            'warehouse' => 'Warehouse',
            'add_first_warehouse' => 'Add First Warehouse',
            'currency' => 'Currency',
            'add_first_currency' => 'Add First Currency',
            'payment_mode' => 'Payment Mode',
            'add_payment_mode' => 'Add First Payment Mode',
            'company_settings' => 'Company Settings',
            'set_company_basic_settings' => 'Setup Company Basic Settings',
            'previous_step' => 'Previous Step',
            'next_step' => 'Next Step',
            'basic_settings' => 'Basic Settings',
            'theme_settings' => 'Theme Settings',
            'logo_settings' => 'Logo Settings',
            'save_finish_setup' => 'Save & Finish Setup',
            'go_to_dashboard' => 'Go To Dashboard',
            'setup_running_message' => 'Please wait... we are setting up inital company settings.',
            'setup_complete_message' => 'Setup completed... Click on below link to view your app...',
        ]
    ];

    public static $eStoreTranslations = [];

    public static function getTranslationArray($moduleName)
    {
        if ($moduleName == 'Estore') {
            return self::$eStoreTranslations;
        } else if ($moduleName == 'Superadmin') {
            return \App\SuperAdmin\Classes\SuperAdminLangTrans::$mainTranslations;
        }

        return self::$mainTranslations;
    }

    public static function seedTranslations($moduleName = '')
    {
        $allLangs = Lang::all();

        $translations = self::getTranslationArray($moduleName);

        foreach ($translations as $group => $translation) {
            foreach ($translation as $transKey => $transValue) {

                foreach ($allLangs as $allLang) {
                    $translationCount = Translation::where('lang_id', $allLang->id)
                        ->where('group', $group)
                        ->where('key', $transKey)
                        ->count();

                    if ($translationCount == 0) {
                        $newTranslation = new Translation();
                        $newTranslation->lang_id = $allLang->id;
                        $newTranslation->group = $group;
                        $newTranslation->key = $transKey;
                        $newTranslation->value = $transValue;
                        $newTranslation->save();
                    }
                }
            }
        }
    }

    public static function seedMainTranslations()
    {
        // Main Module
        self::seedTranslations();

        // Seed Translation for SAAS Version
        if (app_type() == 'saas') {
            self::seedTranslations('Superadmin');
        }
    }

    public static function seedAllModulesTranslations()
    {
        // Main Module
        self::seedMainTranslations();

        $allModules = Module::all();
        foreach ($allModules as $allModule) {
            self::seedTranslations($allModule);
        }
    }
}
